#!/bin/sh

########################################################################
# Author      :  
# Script Name : /mnt/mtdblock/auto.sh
# Description : 
# Version     : V1.0
# Usage       : 
# 
# Log         :
#
########################################################################


export BASE_SCRIPT_FILE="/mnt/mtdblock/script/base.sh"
export GPIO_SCRIPT_FILE="/mnt/mtdblock/script/gpio.sh"

# 检测 auto.sh 是否开启调试模式
[ "$1" == 'D' ] && export DEBUG='yes';

. "$BASE_SCRIPT_FILE" # <-- 加载库脚本文件，不能删除
. "$GPIO_SCRIPT_FILE" # <-- 加载库脚本文件，不能删除

LOGDIR=/mnt/mtdblock/logdir
LOGSUFFIX=.log
LOGLEVEL=EIWD
PUSHLOGLEVEL=EIW

LicdmService=licdm
HubService=hub
OptionsTool=initoptionstool
DevService=devs
BiometricService=biometric
MginitService=mginit
PushService=pushcomm
PullService=pullcomm
StandaloneService=standalonecomm
WebService=webcomm
MainApp=main
LOGDIR=/mnt/mtdblock/logdir


[ "${DEBUG}" != "yes" ] && ifconfig eth0 192.168.1.201 up # <-- 调试模式不设置IP

if [ "${LOGTEST}" = "yes" ]; then
	[ ! -d $LOGDIR ] && mkdir $LOGDIR -p
fi

if [ ! -d /var/tmp ]; then
	mkdir /var/tmp
fi

if [ ! -d /var/lock ]; then
	mkdir /var/lock
fi

if [ ! -d /var/nfftmp ]; then
	mkdir /var/nfftmp
fi

if [ ! -d $DEST2/capture/pass ]; then
	mkdir -p $DEST2/capture/pass
fi

if [ ! -d $DEST2/capture/bad ]; then
	mkdir -p $DEST2/capture/bad
fi

if [ ! -d $DEST2/photo ]; then
	mkdir -p $DEST2/photo
fi

if [ ! -d /usr/lib ]; then
	mkdir -p /usr/lib
fi

rm -rf /var/tmp/*
rm -rf /var/nfftmp/*
rm -rf /var/run/ppp* 
rm -rf /var/run/*.pid
rm -rf /mnt/mtdblock/auto1.sh

if [ -d $DEST/wav/wav ]; then 
	mv $DEST/wav/wav/* $DEST/wav/
	rm -rf $DEST/wav/wav
fi

if [ -d $DEST/wav ]; then
	mkdir -p /mnt/ramdisk/wav && cp $DEST/wav/?[^_]* /mnt/ramdisk/wav/ -rf && sync
fi

if [ ! -f /usr/sbin/pppd ]; then
	cp /mnt/mtdblock/drivers/gprs/* /usr/sbin/. -rf && sync
fi

#还原数据
if [ -f $DEST/data/restore/RestoreOK ]; then 
	filesize=`ls -l $DEST/data/restore/restore.tgz | awk '{ print $5 }'`
	tar -zxvf $DEST/data/restore/restore.tgz -C $DEST/data/ && sync && rm $DEST/data/restore/restore.tgz $DEST/data/restore/RestoreOK -rf
	echo 3 > /proc/sys/vm/drop_caches
	if [ $filesize -ge 55736068 ]
	then
		reboot
	fi
#55736068
fi

#add by don for update wpa_supplicant
if [ -f $DEST/tools/wpa.tgz ]; then 
	tar -zxvf $DEST/tools/wpa.tgz -C / && sync && rm $DEST/tools/wpa.tgz
	
	if [ -f /lib/libcrypto.so.1.0.0 ]; then 
		ln -snf /lib/libcrypto.so.1.0.0 /lib/libcrypto.so;
	fi
	if [ -f /lib/libssl.so.1.0.0 ]; then 
		ln -snf /lib/libssl.so.1.0.0 /lib/libssl.so;
	fi
	if [ -f /lib/libnl.so.1.1.4 ]; then 
		ln -snf /lib/libnl.so.1.1.4 /lib/libnl.so.1;
	fi
	
	if [ -f /lib/libcrypto.so.0.9.8 ]; then 
		rm /lib/libcrypto.so.0.9.8;
	fi
	if [ -f /lib/libnl-3.so.200 ]; then 
		rm /lib/libnl-3.so.200;
	fi
	if [ -f /lib/libnl-genl-3.so.200 ]; then 
		rm /lib/libnl-genl-3.so.200;
	fi
	if [ -f /lib/libssl.so.0.9.8 ]; then 
		rm /lib/libssl.so.0.9.8;
	fi
fi
#end add


#U盘升级二进制文件
if [ -f $DEST/data/update.tgz ]; then 
	tar -zxvf $DEST/data/update.tgz -C / && sync && rm $DEST/data/update.tgz
	echo 3 > /proc/sys/vm/drop_caches
fi

if [ -f $DEST/test.sh ]; then         
	cd $DEST && chmod u+x $DEST/test.sh && $DEST/test.sh
	rm test.sh
fi
if [ -f $DEST/mtdblock.tgz ]; then 
	tar -zxvf $DEST/mtdblock.tgz -C $DEST/ && sync && rm $DEST/mtdblock.tgz
	echo 3 > /proc/sys/vm/drop_caches
fi

if [ -f $DEST/script/decompress.sh ]; then 
	chmod u+x $DEST/script/decompress.sh && $DEST/script/decompress.sh
	rm $DEST/script/decompress.sh
fi

if [ -f $DEST/language.tgz ]; then 
	tar -zxvf $DEST/language.tgz -C $DEST/ && sync && rm $DEST/language.tgz
fi

if [ -f $DEST/languagesig.tgz ]; then 
	tar -xvf $DEST/languagesig.tgz -C $DEST/ && sync && rm $DEST/languagesig.tgz
fi

if [ -d $DEST/app/mginit/language/lang ]; then
	rm -rf $DEST/app/mginit/language/lang
fi

if [ -f $DEST/lib/minires.tgz ]; then
	tar -xzf $DEST/lib/minires.tgz -C /usr/local/lib && sync && rm $DEST/lib/minires.tgz -f &&  sync
fi

#### 运行加载驱动前执行扩展脚本 --profile 状态 ################  add by jigc 2014.12.11##########
if [ -f "$MACHINE_EX_AUTOSH" ]; then 
	$ECHO "\nRuning machine exten script : $(basename ${MACHINE_EX_AUTOSH})  --profile ..."
	. $MACHINE_EX_AUTOSH --profile
	$ECHO "Endof machine exten script : $(basename ${MACHINE_EX_AUTOSH})  --profile ...\n"
fi
#############################################################################################

PorcAutoInsmodDriver # <-- 自动加载驱动，本函数在base.sh 中定义

if [ ! -c /dev/crypt_dev ]; then
	mknod /dev/crypt_dev c 218 0
fi

if [ ! -c /dev/ppp ]; then 
	mknod /dev/ppp c 108 0 
fi

if [ ! -c /dev/zkboard ]; then
	mknod /dev/zkboard c 217 0
fi

#ALGOLIB=$DEST/lib/libzkfp.so.3.5.1

if [ ! -f /etc/MiniGUI.cfg ]; then
	ln -snf $DEST/app/mginit/MiniGUI.cfg /etc/
fi

if [ ! -f /lib/device ]; then
	ln -snf /mnt/mtdblock/lib/device/zkdev /lib/device
fi

if [ -f $DEST/data/udhcpc ]; then
	chmod u+x /mnt/mtdblock/data/udhcpc
	ln -snf /mnt/mtdblock/data/udhcpc /usr/sbin/
fi

#for secugen PIV
if [ -f $LIB/libsecugen.so ]; then
	ln -s $LIB/libsecugen.so /lib/ -f
	ln -s $LIB/libsgfdu04.so /lib/ -f
	ln -s $LIB/libusb.so /lib/ -f
	ln -s /lib/libusb.so /lib/libusb-0.1.so.4 -f
fi

if [ ! -f $LIB/libzkfp.so.9 ]; then
	ln -snf $LIB/libzkfp.so.3.5.1 $LIB/libzkfp.so.3
fi

if [ ! -f $LIB/libzkfp.so.10 ]; then
	ln -snf $LIB/libzkfp.so.4.0.0 $LIB/libzkfp.so.10
fi
if [ ! -f $LIB/libstdc++.so.6 ]; then
	ln -snf $LIB/libc2.so $LIB/libstdc++.so.6
fi
if [ ! -f /usr/lib/libiale_custom.so ]; then
	ln -snf $LIB/libcustom_procs.so /usr/lib/libiale_custom.so
fi

if [ ! -f $LIB/libsoftkeywin.so.0 ]; then
	ln -snf $LIB/libsoftkeywin.so $LIB/libsoftkeywin.so.0
fi

if [ ! -f /lib/libzkweb.so ]; then
	ln -snf $LIB/libzkweb.so /lib/libzkweb.so
fi

if [ ! -f $LIB/libzbar.so.0 ]; then
	ln -snf $LIB/libzbar.so $LIB/libzbar.so.0
fi

AutolinkApplib # <-- 自动建立app链接，本函数在base.sh 中定义

sync


# 运行固件前执行扩展脚本 --pre-runfirmware 状态################################
if [ -f "$MACHINE_EX_AUTOSH" ]; then 
	$ECHO "\nRuning machine exten script : $(basename ${MACHINE_EX_AUTOSH}) --pre-runfirmware ..."
	. $MACHINE_EX_AUTOSH --pre-runfirmware
	$ECHO "Endof machine exten script : $(basename ${MACHINE_EX_AUTOSH}) --pre-runfirmware ...\n"
fi
[ ! -z ${DEBUG} ] && echo "End of Debug..." && return 0
###############################################################################

Service=${LicdmService}
if [ -f $DESTSERVICE/${Service} ]; then
	echo "${Service} run"
	if [ "${LOGTEST}" = "yes" ]; then
		cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
	else
		cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
	fi
fi
echo "${Service} run over"

while [ ! -e /var/tmp/commskt.socket ]; do
	sync
	usleep 50000
done;

#初始化双固件参数
CityRayInitPrm

#此次修改为生产合并映像中U盘升级优化使用########################
#将机器初始化上电后重启两次的操作提前到U盘升级过程中############
#后续打target包固件时需要注意###################################
if [ -f /mnt/mtdblock/tags_usb.txt ]; then
	rm /mnt/mtdblock/tags_usb.txt -rf
	sync
	control_led_for_update_firmware
fi

usleep 50000

Service=${HubService}
if [ -f $DESTSERVICE/${Service} ]; then
	echo "${Service} run"
	if [ "${LOGTEST}" = "yes" ]; then
		cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
	else
		cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
	fi
fi
echo "${Service} run over"

while [ ! -e /var/nfftmp/hub ]; do
	usleep 50000
done;

if [ -f $DESTSERVICE/${OptionsTool} ]; then


	if [ "${LOGTEST}" = "yes" ]; then
		cd $DESTSERVICE && chmod u+x $DESTSERVICE/${OptionsTool} && $DESTSERVICE/${OptionsTool} ${LOGLEVEL} > ${LOGDIR}/${OptionsTool}${LOGSUFFIX}
	else
		cd $DESTSERVICE && chmod u+x $DESTSERVICE/${OptionsTool} && $DESTSERVICE/${OptionsTool}
	fi
fi

Service=${DevService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTSERVICE/${Service} ]; then
		echo "${Service} run"
		if [ "${LOGTEST}" = "yes" ]; then
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
		fi
	fi
	
	while [ ! -e /var/nfftmp/dev ]; do
		usleep 50000
	done;
fi
echo "${Service} run over"

usleep 50000

usleep 50000
usleep 50000

Service=${MginitService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTAPP/mginit/${Service} ]; then
		echo "${Service} run"
		if [ "${LOGTEST}" = "yes" ]; then
			cd $DESTAPP/mginit && chmod u+x $DESTAPP/mginit/${Service} && $DESTAPP/mginit/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTAPP/mginit && chmod u+x $DESTAPP/mginit/${Service} && $DESTAPP/mginit/${Service} &
		fi
	fi
fi
echo "${Service} run over"

usleep 50000
usleep 50000

if [ "${LOGTEST}" != "yes" ]; then 
	while [ ! -e /var/nfftmp/main ]; do
		usleep 50000
	done;
fi


usleep 50000 && usleep 50000
usleep 50000 && usleep 50000
usleep 50000 && usleep 50000
usleep 50000 && usleep 50000
usleep 50000 && usleep 50000
usleep 50000 && usleep 50000
usleep 50000

Service=${PushService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTSERVICE/${Service} ]; then
		echo "${Service} run"
		if [ "${LOGTEST}" = "yes" ]; then
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${PUSHLOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
		fi
	fi
fi
echo "${Service} run over"

usleep 50000

Service=${PullService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTSERVICE/${Service} ]; then
		echo "${Service} run"
		if [ "${LOGTEST}" = "yes" ]; then
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
		fi
	fi
fi
echo "${Service} run over"

usleep 50000

Service=${StandaloneService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTSERVICE/${Service} ]; then
		echo "${Service} run"
		if [ "${LOGTEST}" = "yes" ]; then
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
		fi
	fi
fi
echo "${Service} run over"

usleep 50000

Service=${WebService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTSERVICE/${Service} ]; then
		echo "${Service} run"
		if [ "${LOGTEST}" = "yes" ]; then
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
		fi
	fi
fi
echo "${Service} run over"

Service=${BiometricService}
pgrep ${Service} > /dev/nul
if [ "$?" != 0 ]; then
	if [ -f $DESTSERVICE/${Service} ]; then
		echo "${Service} run"
		if [ -f "$USER_DB_FILE" ]; then # <-- 条件成立则开启 biometric 调试模式并统计通过率(需配合U盘抓取日志功能使用)
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service}  
			$DESTSERVICE/${Service} EWDI | analysisBiolog-V1.0.awk SAVE_BMP_FILE_DIR=$FINGER_BMP_FILE_DIR RAW_BIO_LOG_FILE=$RAW_BIO_LOG_FILE "$USER_DB_FILE" -  &
		elif [ "${LOGTEST}" = "yes" ]; then
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} ${LOGLEVEL} > ${LOGDIR}/${Service}${LOGSUFFIX} &
		else
			cd $DESTSERVICE && chmod u+x $DESTSERVICE/${Service} && $DESTSERVICE/${Service} &
		fi
	fi
fi
echo "${Service} run over"

if [ "${LOGTEST}" = "yes" ]; then
	while [ ! -e /var/tmp/minigui ]; do
		usleep 50000
	done;
	
	sleep 1 # <-- 休眠1秒解决U盘抓日志开启后main启动卡在 JoinLayer 接口的问题
	
	pgrep ${MainApp} > /dev/nul
	if [ "$?" != 0 ]; then
		if [ -f $DESTAPP/main/${MainApp} ]; then
			echo "${MainApp} run"
			cd $DESTAPP/main && chmod u+x $DESTAPP/main/${MainApp} && $DESTAPP/main/${MainApp} ${LOGLEVEL} > ${LOGDIR}/${MainApp}${LOGSUFFIX} &
		fi
	fi
fi
echo "${MainApp} run over"

if [ -f $DEST/data/wdt ]; then
	cd $DEST/data && chmod u+x $DEST/data/wdt && $DEST/data/wdt -p 5 -t 3600 -m "$DEST/app/main/main"
fi

#for ssh
if [ -f $DEST/sshres.tgz ]; then
	cd $DEST && tar zxvf sshres.tgz -C / && sync && rm sshres.tgz	
fi

ln -s /mnt/mtdblock/lib/libutil-2.6.1.so /lib/libutil.so.1
dropbear -p 22
killall telnetd
#ssh end

